/*- AccelAttachListener -
 * populate the available fields and controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.AccelerometerPhidget;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AccelAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numAxesTxt;
    private JTextField accel3Txt;
    private JTextField sensitivity1Txt;
    private JTextField sensitivity2Txt;
    private JTextField sensitivity3Txt;
    
    /** Creates a new instance of AccelAttachListener */
    public AccelAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numAxesTxt,
            JTextField accel3Txt, JTextField sensitivity1Txt, JTextField sensitivity2Txt, JTextField sensitivity3Txt)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numAxesTxt = numAxesTxt;
        this.accel3Txt = accel3Txt;
        this.sensitivity1Txt = sensitivity1Txt;
        this.sensitivity2Txt = sensitivity2Txt;
        this.sensitivity3Txt = sensitivity3Txt;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            AccelerometerPhidget attached = (AccelerometerPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numAxesTxt.setText(Integer.toString(attached.getAxisCount()));
            
            sensitivity1Txt.setEnabled(true);
            sensitivity2Txt.setEnabled(true);
            
            if(attached.getAxisCount() > 2)
            {
                sensitivity3Txt.setEnabled(true);
            }
            else
            {
                sensitivity3Txt.setEnabled(false);
            }
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
